/**
 *
 * Klasse Kartenspiel
 *
 * @version 1.0 vom 01.03.2024
 * @AAK 
 */
import java.util.ArrayList;

public class Kartenspiel {
  // Anfang Attribute
  private ArrayList<Karte> aufnahmestapel;
  private ArrayList<Karte> ablagestapel;
  private ArrayList<Karte> handkarten;
  // Ende Attribute
  
  /** Konstruktor
   */
  public Kartenspiel() {
    aufnahmestapel = new ArrayList<Karte>(); 
    ablagestapel = new ArrayList<Karte>();  
    handkarten = new ArrayList<Karte>();
    
    ArrayList<String> farben = new ArrayList<String>();
    farben.add("rot");
    farben.add("blau");
    for (String farbe : farben) {
      for (int wert = 1; wert <= 10; wert++) {
        Karte karte = new Karte(farbe, wert);
        aufnahmestapel.add(karte);
      }
    }
  }
  
  // Anfang Methoden
  /** gibt Liste von aufnahmestapel zurueck
  * @return aufnahmestapel 
  */
  public ArrayList<Karte> getAufnahmestapel() {
    return aufnahmestapel;
  }
  
  /** gibt Liste von ablagestapel zurueck
  * @return ablagestapel 
  */
  public ArrayList<Karte> getAblagestapel() {
    return ablagestapel;
  }
  
  /** gibt Liste von handkarten zurueck
  * @return handkarten 
  */
  public ArrayList<Karte> getHandkarten() {
    return handkarten;
  }
  
  /** Ziehen der obersten Karte von aufnahmestapel und Einordnung in handkarten
  */
  public void zieheObersteKarte() {
    Karte karteOben;    
    int anzahl = aufnahmestapel.size();
    if (anzahl > 0) {
      karteOben = aufnahmestapel.get(anzahl-1);
      aufnahmestapel.remove(anzahl-1);
      handkarten.add(karteOben);
    }
  }

  /** Ziehen einer zufaelligen Karte von aufnahmestapel und Einordnung in handkarten
  */
  public void zieheZufaelligeKarte() {
    Karte karte;
    int i;
    // Beginn Schritt 1: Hier Kommentar ergaenzen
    int anzahl = aufnahmestapel.size();
    // Ende Schritt 1
    if (anzahl > 0) {
      // Beginn Schritt 2: Hier Kommentar ergaenzen
      i = (int) (Math.random() * anzahl);
      // Ende Schritt 2
      // Beginn Schritt 3: Hier Kommentar ergaenzen
      karte = aufnahmestapel.get(i);
      aufnahmestapel.remove(i);
      handkarten.add(karte);
      // Ende Schritt 3
    }
  }

  /** Mischen der Karten von aufnahmestapel
  */
  public void mischeAufnahmestapel() {
    Karte karte, karteZufall;
    int indexZufall;
    
    // Hier Quelltext ergaenzen
    
    
  }
  
  /** Ausgabe der Karten des Kartenspiels in formatierter Form
  */
  public void zeigeKartenFormatiert() {
    String ausgabe1 = "";
    String ausgabe2 = "";
    String ausgabe3 = "";
    
    for (Karte karte: aufnahmestapel) {
      ausgabe1 = ausgabe1 + karte.getFarbe() + "-" + karte.getWert() + "  ";
    }
    for (Karte karte: ablagestapel) {
      ausgabe2 = ausgabe2 + karte.getFarbe() + "-" + karte.getWert() + "  ";
    }
    for (Karte karte: handkarten) {
      ausgabe3 = ausgabe3 + karte.getFarbe() + "-" + karte.getWert() + "  ";
    }
    
    System.out.println("Aufnahmestapel: " + ausgabe1);
    System.out.println("Ablagestapel: " + ausgabe2);
    System.out.println("Handkarten: " + ausgabe3);
  }
}