import tkinter as tk
from tkinter import font as tkfont
from codemanipulation import Codemanipulation  # Import mit kleinem 'c'

class GUI(tk.Tk):
    def __init__(self):
        super().__init__()
        self.title("GUI")
        self.geometry("721x313")
        self.configure(bg="white")
        self.resizable(False, False)

        # Initialisierung der Fachklasse
        self.manipulator = Codemanipulation()

        # Komponenten
        self.lStrichcode = tk.Label(self, text="Strichcode", anchor="w", font=tkfont.Font(weight="bold"), bg="white")
        self.lStrichcode.place(x=15, y=72, width=260, height=19)

        self.lErweiterterStrichcode = tk.Label(self, text="erweiterter Strichcode", anchor="w", font=tkfont.Font(weight="bold"), bg="white")
        self.lErweiterterStrichcode.place(x=15, y=128, width=260, height=19)

        self.tfStrichcode = tk.Entry(self, font=tkfont.Font(size=10))
        self.tfStrichcode.place(x=15, y=89, width=260, height=25)
        self.tfStrichcode.insert(0, self.manipulator.getStrichcode())

        self.tfErweiterterStrichcode = tk.Entry(self, font=tkfont.Font(size=10))
        self.tfErweiterterStrichcode.place(x=15, y=146, width=260, height=25)

        self.btErzeugen = tk.Button(self, text="Erzeugen", command=self.btErzeugen_ActionPerformed, font=tkfont.Font(weight="bold"), bg="#4CAF50", fg="black")
        self.btErzeugen.place(x=15, y=180, width=150, height=30)

        self.lStrichcodeManipulation = tk.Label(self, text="Strichcode-Manipulation", font=tkfont.Font(size=24, weight="bold"), bg="white")
        self.lStrichcodeManipulation.place(x=15, y=14, width=700, height=35)

        self.lAlternativerStrichcode = tk.Label(self, text="Alternative Darstellung des Strichcodes", anchor="w", font=tkfont.Font(weight="bold"), bg="white")
        self.lAlternativerStrichcode.place(x=315, y=125, width=360, height=19)

        self.tfAlternativerStrichcode = tk.Entry(self, font=tkfont.Font(size=10))
        self.tfAlternativerStrichcode.place(x=315, y=146, width=350, height=25)

        self.btTransformieren = tk.Button(self, text="Transformieren", command=self.btTransformieren_ActionPerformed, font=tkfont.Font(weight="bold"), bg="#2196F3", fg="black")
        self.btTransformieren.place(x=315, y=180, width=150, height=30)

    def btErzeugen_ActionPerformed(self):
        """Methode, die beim Klicken auf den 'Erzeugen'-Button ausgefuehrt wird."""
        self.manipulator.setStrichcode(self.tfStrichcode.get())
        self.tfErweiterterStrichcode.delete(0, tk.END)
        self.manipulator.erweitern()
        self.tfErweiterterStrichcode.insert(0, self.manipulator.getErweiterterStrichcode())

    def btTransformieren_ActionPerformed(self):
        """Methode, die beim Klicken auf den 'Transformieren'-Button ausgefuehrt wird."""
        self.manipulator.setStrichcode(self.tfStrichcode.get())
        self.tfAlternativerStrichcode.delete(0, tk.END)
        self.manipulator.transformieren()
        self.tfAlternativerStrichcode.insert(0, self.manipulator.getAlternativerStrichcode())

if __name__ == "__main__":
    app = GUI()
    app.mainloop()
