import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 03.04.2022
 * @author 
 */

public class GUI extends JFrame {
  // Anfang Attribute
  private JLabel lStrichcode = new JLabel();
  private JLabel lErweiterterStrichcode = new JLabel();
  private JTextField tfStrichcode = new JTextField();
  private JTextField tfErweiterterStrichcode = new JTextField();
  private JButton btErzeugen = new JButton();
  private JLabel lStrichcodeManipulation = new JLabel();
  private Codemanipulation manipulator = new Codemanipulation();
  private JLabel lAlternativerStrichcode = new JLabel();
  private JTextField tfAlternativerStrichcode = new JTextField();
  private JButton btTransformieren = new JButton();
  private JButton bBeenden = new JButton();
  // Ende Attribute
  
  public GUI() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 721; 
    int frameHeight = 341;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("GUI");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    lStrichcode.setBounds(8, 56, 296, 19);
    lStrichcode.setText("Strichcode");
    lStrichcode.setFont(new Font("Dialog", Font.BOLD, 11));
    cp.add(lStrichcode);
    
    lErweiterterStrichcode.setBounds(8, 120, 296, 19);
    lErweiterterStrichcode.setText("erweiterter Strichcode");
    lErweiterterStrichcode.setFont(new Font("Dialog", Font.BOLD, 11));
    cp.add(lErweiterterStrichcode);
    
    tfStrichcode.setBounds(8, 72, 296, 32);
    tfStrichcode.setText("s1");
    tfStrichcode.setFont(new Font("Dialog", Font.PLAIN, 12));
    cp.add(tfStrichcode);
    
    tfErweiterterStrichcode.setBounds(8, 136, 296, 32);
    tfErweiterterStrichcode.setFont(new Font("Dialog", Font.PLAIN, 12));
    cp.add(tfErweiterterStrichcode);
    
    btErzeugen.setBounds(64, 184, 176, 32);
    btErzeugen.setText("Erzeugen");
    btErzeugen.setMargin(new Insets(2, 2, 2, 2));
    btErzeugen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btErzeugen_ActionPerformed(evt);
      }
    });
    btErzeugen.setSelected(true);
    btErzeugen.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(btErzeugen);
    
    lStrichcodeManipulation.setBounds(8, 8, 672, 32);
    lStrichcodeManipulation.setText("Strichcode-Manipulation");
    lStrichcodeManipulation.setFont(new Font("Dialog", Font.BOLD, 24));
    cp.add(lStrichcodeManipulation);
    
    lAlternativerStrichcode.setBounds(360, 120, 296, 19);
    lAlternativerStrichcode.setText("Alternative Darstellung des Strichcodes");
    lAlternativerStrichcode.setFont(new Font("Dialog", Font.BOLD, 11));
    cp.add(lAlternativerStrichcode);
    
    tfAlternativerStrichcode.setBounds(360, 136, 296, 32);
    tfAlternativerStrichcode.setFont(new Font("Dialog", Font.PLAIN, 12));
    cp.add(tfAlternativerStrichcode);
    
    btTransformieren.setBounds(416, 184, 176, 32);
    btTransformieren.setText("Transformieren");
    btTransformieren.setMargin(new Insets(2, 2, 2, 2));
    btTransformieren.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btTransformieren_ActionPerformed(evt);
      }
    });
    btTransformieren.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(btTransformieren);
    
    bBeenden.setBounds(240, 256, 168, 33);
    bBeenden.setText("Beenden");
    bBeenden.setMargin(new Insets(2, 2, 2, 2));
    bBeenden.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bBeenden_ActionPerformed(evt);
      }
    });
    bBeenden.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(bBeenden);
    // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new GUI();
  }
  
  public void btErzeugen_ActionPerformed(ActionEvent evt) {
    manipulator.setStrichcode(tfStrichcode.getText());
    tfErweiterterStrichcode.setText("");
    manipulator.erweitern();
    tfErweiterterStrichcode.setText(manipulator.getErweiterterStrichcode());
  }

  public void btTransformieren_ActionPerformed(ActionEvent evt) {
    manipulator.setStrichcode(tfStrichcode.getText());
    tfAlternativerStrichcode.setText("");
    manipulator.transformieren();
    tfAlternativerStrichcode.setText(manipulator.getAlternativerStrichcode());
  }

  public void bBeenden_ActionPerformed(ActionEvent evt) {
    System.exit(0);
    
  }

   // Ende Methoden
}
