"""
 Klasse Kartenspiel

 @version 1.0 vom 2025-01-09
 @AAK 
"""
import random
from karte import *

class Kartenspiel:
    
    def __init__(self):
        """
        Konstruktor
        """
        self.__aufnahmestapel = []
        self.__ablagestapel = []
        self.__handkarten = []

        farben = ["rot", "blau"]
        for farbe in farben:
            for wert in range(1, 11):
                karte = Karte(farbe, wert)
                self.__aufnahmestapel.append(karte)
    
    # Anfang Methoden
    def getAufnahmestapel(self):
        """
        gibt Liste von aufnahmestapel zurueck
        Rueckgabe: aufnahmestapel
        """
        return self.__aufnahmestapel

    def getAblagestapel(self):
        """
        gibt Liste von ablagestapel zurueck
        Rueckgabe: ablagestapel
        """
        return self.__ablagestapel

    def getHandkarten(self):
        """
        gibt Liste von handkarten zurueck
        Rueckgabe: handkarten
        """
        return self.__handkarten

    def zieheObersteKarte(self):
        """
        Ziehen der obersten Karte von aufnahmestapel und Einordnung in handkarten
        """
        karteOben = None
        anzahl = len(self.__aufnahmestapel)
        if anzahl > 0:
            karteOben = self.__aufnahmestapel[anzahl - 1]
            self.__aufnahmestapel.pop(anzahl - 1)
            self.__handkarten.append(karteOben)

    def zieheZufaelligeKarte(self):
        """
        Ziehen einer zufaelligen Karte von aufnahmestapel und Einordnung in handkarten
        """
        karte = None
        i = 0
        # Beginn Schritt 1: Hier Kommentar ergaenzen
        anzahl = len(self.__aufnahmestapel)
        # Ende Schritt 1
        if anzahl > 0:
            # Beginn Schritt 2: Hier Kommentar ergaenzen
            i = int(random.random() * anzahl)
            # Ende Schritt 2
            # Beginn Schritt 3: Hier Kommentar ergaenzen
            karte = self.__aufnahmestapel[i]
            self.__aufnahmestapel.pop(i)
            self.__handkarten.append(karte)
            # Ende Schritt 3

    def legeKarteAb(self, pIndex):
        """
        Ziehen der Karte mit Index pIndex aus handkarten und Ablage auf ablagestapel
        Parameter pIndex: Index der Karte in handkarten
        """
        # Hier Quelltext einfuegen

    def mischeAufnahmestapel(self):
        """
        Mischen der Karten von aufnahmestapel
        """
        karte = None
        karteZufall = None
        indexZufall = 0
        
        # Hier Quelltext ergaenzen

    def zeigeKartenFormatiert(self):
        """
        Ausgabe der Karten des Kartenspiels in formatierter Form
        """
        ausgabe1 = ""
        ausgabe2 = ""
        ausgabe3 = ""

        for karte in self.__aufnahmestapel:
            ausgabe1 = ausgabe1 + karte.getFarbe() + "-" + str(karte.getWert()) + "  "
        for karte in self.__ablagestapel:
            ausgabe2 = ausgabe2 + karte.getFarbe() + "-" + str(karte.getWert()) + "  "
        for karte in self.__handkarten:
            ausgabe3 = ausgabe3 + karte.getFarbe() + "-" + str(karte.getWert()) + "  "
            
        print("Aufnahmestapel:" + ausgabe1)
        print("Ablagestapel:" + ausgabe2)
        print("Handkarten:" + ausgabe3)
    # Ende Methoden